#include <algorithm>
#include <cstdint>
#include <cstring>
#include <iostream>
#include <stack>
#include <tuple>
#include <unordered_map>
#include <vector>

typedef std::unordered_map<uint16_t, std::unordered_map<uint16_t, int16_t>> Graph;
constexpr int16_t INF = 30000;
constexpr int16_t NEG_INF = -30000;
constexpr int16_t unvisited = -1;

[[gnu::noreturn]]
void solve(const std::string& circle, const uint32_t circle_size) noexcept {
	constexpr char DELIVERY = '#';
	constexpr char CHARACTER = '+';
	constexpr char EMPTY = '.';
	
	uint32_t left_distance;
	uint32_t right_distance;
	uint32_t it;
	uint32_t lit;
	uint32_t rit;
	uint32_t character_position;
	bool wrap;

	// prvo nadjemo +
	for(it = 0; it < circle_size; ++it)
		if(circle[it] == CHARACTER)
			character_position = it;

	// sad nadjemo levo
	wrap = false;
	for(lit = character_position; true; --lit) { // ne smem character_position - 1 jer bi bio integer underflow ako je 0
	left:
		if(circle[lit] == DELIVERY) {
			if(wrap == true)
				left_distance = character_position + (circle_size - lit); // . . . + #, okej
			else
				left_distance = character_position - lit; // # . . . +, . . # . +, okej
			break;
		}
		if(lit == 0) {
			wrap = true;
			lit = circle_size - 1;
			goto left;
		}
	}

	wrap = false;
	for(rit = character_position; true; ++rit) {
	right:
		if(circle[rit] == DELIVERY) {
			if(wrap == true)
				right_distance = (circle_size - character_position) + rit;
			else
				right_distance = rit - character_position;
			break;
		}
		if(rit == circle_size - 1) {
			wrap = true;
			rit = 0;
			goto right;
		}
	}

	std::cout << std::min(left_distance, right_distance);
	std::exit(0);
}

int main() noexcept {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);
  std::cout.tie(nullptr);
  std::cerr.tie(nullptr);
	
	// constexpr uint32_t MAX_SIZE = 500000;
	std::string circle;
	uint32_t circle_size;
	char newline;

	std::cin >> circle_size;
	circle.reserve(circle_size);

	std::cin.ignore(1, '\n');
	std::getline(std::cin, circle);

	//std::cout << circle;
	//std::cout << circle_size;

	solve(circle, circle_size);
}